﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PracownicyEmaile.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.PracownicyEmaile" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title>Pracownicy emaile</title>
  <link href="../Web.css?2" type="text/css" rel="stylesheet" />
  <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
  <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
  <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
  <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
  <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
  <script type="text/javascript">
    $(function () {
      $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
      $("#btnPowrot").button({ icons: { primary: 'ui-icon-arrowreturnthick-1-w' } });
      $("#btnWybierz").button({ icons: { primary: 'ui-icon-check' } });

        $('#tbData').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
        $("#tbData").datepicker("option", "dateFormat", 'yy-mm-dd');

    });

      function CopyToClipboard() {
          var copyText = "";
          $('#<%= gvListy.ClientID %> input[type="checkbox"]:checked').each(function () {
              var row = $(this).closest("tr")[0];
              if (row.cells[4].innerHTML != '&nbsp;')
                  copyText += row.cells[4].innerHTML+";";

          });
          //alert(copyText); 
          if (window.isSecureContext && navigator.clipboard) {
              //wymaga https lub localnie
              navigator.clipboard.writeText(copyText)
                  .then(() => { alert('Skopiowano do schowka.') })
                  .catch((error) => { alert('Błąd kopiowania: ${error}') })
          }
          else {
              unsecuredCopyToClipboard(copyText)
          }
      }

      function unsecuredCopyToClipboard(text) {
          const textArea = document.createElement("textarea");
          textArea.value = text;
          document.body.appendChild(textArea);
          //textArea.focus();
          textArea.focus({ preventScroll: true })
          textArea.select();
          try {
              document.execCommand('copy');
              alert('Skopiowano do schowka.')
          } catch (err) {
              alert('Błąd kopiowania do schowka: ' + err);
              console.error('Unable to copy to clipboard', err);
          }
          document.body.removeChild(textArea);
      }

  </script>
</head>
<body class="body">
  <form id="form1" runat="server">
    <div>
      <table class="Body" border="0" cellspacing="5px" cellpadding="0" width="100%">
        <tr>
          <td colspan="6">
            <asp:Label ID="lblOpis" runat="server" Font-Size="Medium" Font-Bold="True">Pracownicy e-maile</asp:Label>
          </td>
        </tr>
        <tr>
          <td colspan="6">
            <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label></td>
        </tr>
        <tr>
          <td style="width: 200px">
            <small>Data</small><br />
            <asp:TextBox ID="tbData" runat="server" Width="70%"></asp:TextBox>
          </td>
          <td style="width: 30%">
            <small>&nbsp;</small><br />
            <asp:LinkButton ID="btnOdswiez" runat="server" Width="90px" CssClass="Button" Text="Odśwież" OnClick="btnOdswiez_Click"></asp:LinkButton>
          </td>
          <td style="text-align: right">
            <div style="float: right">
              <small>&nbsp;</small><br />
              <asp:LinkButton ID="btnWybierz" runat="server" Width="200px" CssClass="Button" Text="Kopiuj maile do schowka" OnClientClick="CopyToClipboard();return false;"></asp:LinkButton>
            </div>
          </td>
        </tr>

      </table>
    </div>

    <div>
      <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
        <div style="float: left; position: absolute; bottom: 2px;">
          <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
        </div>
      </div>
      <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="IdPracownika,Nazwisko,Imie,Login,Email" >
        <Columns>
          <asp:TemplateField ShowHeader="False">
            <ItemTemplate>
              <asp:CheckBox ID="cbWybierz" runat="server" Checked="true" />
            </ItemTemplate>
            <ControlStyle Width="20px" />
            <HeaderStyle Width="20px" />
            <ItemStyle VerticalAlign="Middle" Width="20px" />
          </asp:TemplateField>
          <asp:BoundField DataField="Nazwisko" HeaderText="Nazwisko" SortExpression="Nazwisko" />
          <asp:BoundField DataField="Imie" HeaderText="Imię" SortExpression="Imie" />
          <asp:BoundField DataField="Login" HeaderText="Login" SortExpression="Login" />
          <asp:BoundField DataField="Email" HeaderText="Mail" SortExpression="Email" />
          <asp:BoundField DataField="Jednostka" HeaderText="Jednostka" SortExpression="Jednostka" />
          <asp:BoundField DataField="Stanowisko" HeaderText="Stanowisko" SortExpression="Stanowisko" />
          <asp:BoundField DataField="RodzajUmowy" HeaderText="Rodzaj" SortExpression="RodzajUmowy" />
        </Columns>
        <PagerSettings Position="Top" />
        <RowStyle CssClass="TableItem" />
        <SelectedRowStyle CssClass="TableItemSelected" />
        <HeaderStyle CssClass="TableHeader" />
        <AlternatingRowStyle CssClass="TableItemAlt" />
      </asp:GridView>
    </div>
      <asp:ObjectDataSource ID="sdsListy" runat="server" SelectMethod="Pobierz" TypeName="iKPService.PracownicyEmaile" OnSelecting="sdsListy_Selecting" SortParameterName="sortExpression">
          <SelectParameters>
              <asp:Parameter Name="blpString" Type="String" />
              <asp:Parameter DefaultValue="www" Name="rodzaj" Type="String" />
          </SelectParameters>
      </asp:ObjectDataSource>
  </form>
</body>
</html>


